import Utilities.visa_operations as vo
import Utilities.gui_creator as gc

root = gc.create_window(title='Simple VISA Query',
                        size='700x150')

resource_name = \
           'USB0::0x0957::0x0607::MY47022122::INSTR'

rm, dmm = vo.open_session(resource_name)

def perform_query():

    command = gc.get_control_string(var_ent)
    vo.write_instrument(dmm, command)
    response = vo.read_instrument(dmm)
#    response = response[:-1]
    lbl_resp.config(text=response)
#    lbl_resp.config(text=repr(response))

    return

var_ent = gc.create_control(root, label='Command',
                            char_width=60)

lbl_resp = gc.create_indicator(root, 
                               label_1='Response',
                               char_width=60)

btn = gc.action_button(root, label='Submit',
                       action=perform_query)

root.mainloop()

vo.close_session(rm, dmm)

